' Textured Cube
' by Mindless
' 
'   Feel free to use this however you want. Please note that some of the
' code is not mine. It is stolen from a program that did not have a
' noted author.

DECLARE SUB BMPInfo ()
DECLARE SUB DrawCube (Model() AS ANY, Vector() AS ANY)
DECLARE SUB LoadCube (Model() AS ANY, Vector() AS ANY)
DECLARE SUB RotateAndProject (Model() AS ANY, AngleX%, AngleY%, AngleZ%)
'$INCLUDE: 'future.bi'

DEFINT A-Z
REM $DYNAMIC

TYPE Point3D
        X       AS SINGLE                   'Normal 3d coords
        Y       AS SINGLE
        Z       AS SINGLE
        Xr      AS SINGLE
        Yr      AS SINGLE
        Zr      AS SINGLE
        ScrX    AS INTEGER                  'Translated and projected
        ScrY    AS INTEGER                  '2d Coords
END TYPE

TYPE VectorType
        V1      AS INTEGER
        V2      AS INTEGER
        V3      AS INTEGER
END TYPE

CONST PI = 3.14151693#

DIM SHARED Pic%(22505), CubeError$, BMPFileName$
DIM SHARED BMPWidth AS INTEGER, BMPHeight AS INTEGER, BMPBPP AS INTEGER

DIM SHARED LCOS(359) AS SINGLE              'Lookup Table
DIM SHARED LSIN(359) AS SINGLE

REDIM SHARED CubeModel(1) AS Point3D        'Original Cube model
REDIM SHARED CubeVector(1) AS VectorType    'Connection Points
DIM SHARED MaxVertex, MaxVector             'Maximum Vertex of cube
                                            'and Maximum Points to connect
DIM SHARED ThetaX, ThetaY, ThetaZ           'X,Y,Z angles of rotation
DIM SHARED ZCenter, CamX, CamY              'CenterZ and Camera
DIM SHARED XCenter, YCenter

BMPFileName$ = COMMAND$
IF BMPFileName$ = "" THEN BMPFileName$ = "Cube.bmp"

BMPInfo
IF (BMPWidth * BMPHeight) + 4 > 22505 THEN CubeError$ = "BMPTOOBIG"
IF CubeError$ <> "" THEN GOTO Shutdown

Set640x480 BMPBPP
IF Pages < 2 THEN CubeError$ = "PAGES"
IF CubeError$ <> "" THEN GOTO Shutdown
Future.LoadBMP BMPFileName$, 0, 0
Future.Get 0, 0, BMPWidth - 1, BMPHeight - 1, Pic%()
Future.CLS 0

'PreCalc sin and cos lookuptable

FOR I = 0 TO 359
    a! = I * PI / 180
    LCOS(I) = COS(a!)
    LSIN(I) = SIN(a!)
NEXT I

LoadCube CubeModel(), CubeVector()          'Load the model

RANDOMIZE TIMER

'Init the Angles
ThetaX = 0
ThetaY = 0
ThetaZ = 0
ZCenter = 250
XCenter = 160
YCenter = 100
Xv = ((RND * 6) - 2.5)
Yv = ((RND * 6) - 2.5)
IF INT(Yv) = 0 THEN Yv = ((RND * 6) - 2.5)
IF INT(Xv) = 0 THEN Xv = ((RND * 6) - 2.5)

Future.CLS 0
Bump = ZCenter / 2.727273
DO
        P% = P% XOR 1
        SetPage P%
        WAIT &H3DA, 8
        WAIT &H3DA, 8, 8
        Future.FillBox XCenter - 100, YCenter - 100, XCenter + 100, YCenter + 100, 0
       
        XCenter = XCenter + Xv
        IF XCenter > 639 - Bump THEN
            Xv = -Xv
        ELSEIF XCenter < 0 + Bump THEN
            Xv = -Xv
        END IF

        YCenter = YCenter + Yv
        IF YCenter > 479 - Bump THEN
            Yv = -Yv
        ELSEIF YCenter < 0 + Bump THEN
            Yv = -Yv
        END IF



        ThetaX = (ThetaX + 1) MOD 360       'Rotate the Angles
        ThetaY = (ThetaY + 1) MOD 360
        ThetaZ = (ThetaZ + 1) MOD 360

        'Rotate and Project the Model
        RotateAndProject CubeModel(), ThetaX, ThetaY, ThetaZ

        'Draw and Fill
        DrawCube CubeModel(), CubeVector()

        ViewPage P%
LOOP UNTIL INKEY$ <> ""           'Quit if ESCAPE is pressed
Shutdown:
ResetScreen
END

NumPoints:         'Number of Points on the Cube
DATA 8

VertexData:        'Vertices of Points on the Cube
DATA -50,-50,-50
DATA  50,-50,-50
DATA  50, 50,-50
DATA -50, 50,-50
DATA -50,-50, 50
DATA  50,-50, 50
DATA  50, 50, 50
DATA -50, 50, 50
     
NumVector:         'Number of Vectors
DATA 12

ConnectData:       'Vector Point Connecting Data
DATA 5,1,8,  1,4,8,  6,5,7,  5,8,7,  2,6,3,  6,7,3
DATA 1,2,4,  2,3,4,  4,3,8,  3,7,8,  5,6,1,  6,2,1

REM $STATIC
DEFSNG A-Z
SUB BMPInfo
  BMP = FREEFILE
  OPEN BMPFileName$ FOR BINARY AS #BMP
  IF LOF(BMP) = 0 THEN
    CubeError$ = "BMPEMPTY"
    CLOSE #BMP
    KILL FileName$
    EXIT SUB
  END IF
  ValidBMP$ = SPACE$(2)
  GET #BMP, 1, ValidBMP$
  IF ValidBMP$ <> "BM" THEN CubeError$ = "BMPINVALID": EXIT SUB
  Junk$ = SPACE$(12)
  PixelWidth$ = SPACE$(4): PixelHeight$ = SPACE$(4)
  BitsPerPixel$ = SPACE$(2): Junk$ = SPACE$(2)
  GET #BMP, 3, Junk$
  GET #BMP, 19, PixelWidth$
  GET #BMP, 23, PixelHeight$
  GET #BMP, 27, Junk$
  GET #BMP, 29, BitsPerPixel$
  BMPWidth = CVL(PixelWidth$)
  BMPHeight = CVL(PixelHeight$)
  BMPBPP = CVI(BitsPerPixel$)
  IF BMPBPP > 15 THEN BMPBPP = 15
  CLOSE #BMP
END SUB

DEFINT A-Z
SUB DrawCube (Model() AS Point3D, Vector() AS VectorType) STATIC
  FOR I = 1 TO MaxVector
    X1 = Model(Vector(I).V1).ScrX       'Get triangles from "projected"
    X2 = Model(Vector(I).V2).ScrX       'X and Y coords since Znormal
    X3 = Model(Vector(I).V3).ScrX       'Does not require a Z coord
    Y1 = Model(Vector(I).V1).ScrY       'V1= Point1 connected to V2 then
    Y2 = Model(Vector(I).V2).ScrY       'V2 to V3 and so on...
    Y3 = Model(Vector(I).V3).ScrY
         
    'Use the Znormal,the Ray perpendicular(Orthogonal) to the Screen
    'Defined by the Triangle (X1,Y1,X2,Y2,X3,Y3)
    'if Less(<) 0 then its facing in the opposite direction so
    'don't plot. If =>0 then its facing towards you so Plot.

    Znormal = (X2 - X1) * (Y1 - Y3) - (Y2 - Y1) * (X1 - X3)
    IF Znormal < 0 THEN
      IF INT(I / 2) = I / 2 THEN
        Future.TRITEXT X1%, Y1%, X2%, Y2%, X3%, Y3%, 0, 0, Pic%(0) + 1, 0, Pic%(0) + 1, Pic%(1) + 1, Pic%()
      ELSE
        Future.TRITEXT X1%, Y1%, X2%, Y2%, X3%, Y3%, 0, Pic%(1) + 1, 0, 0, Pic%(0) + 1, Pic%(1) + 1, Pic%()
      END IF
    END IF
  NEXT I
END SUB

SUB LoadCube (Model() AS Point3D, Vector() AS VectorType) STATIC

RESTORE NumPoints
READ MaxVertex
REDIM Model(1 TO MaxVertex) AS Point3D


RESTORE VertexData
FOR V = 1 TO MaxVertex
    READ Xt, Yt, Zt
    Model(V).X = Xt
    Model(V).Y = Yt
    Model(V).Z = Zt
NEXT V

RESTORE NumVector
READ MaxVector
REDIM Vector(MaxVector) AS VectorType

RESTORE ConnectData

FOR V = 1 TO MaxVector
        READ VT1, VT2, VT3
        Vector(V).V1 = VT1
        Vector(V).V2 = VT2
        Vector(V).V3 = VT3
NEXT V

END SUB

SUB RotateAndProject (Model() AS Point3D, AngleX, AngleY, AngleZ) STATIC

DIM X AS SINGLE             'Temporary rotation vars
DIM Y AS SINGLE
DIM Z AS SINGLE

DIM CX AS SINGLE            'Cos and Sin of each rotation angle
DIM Sx AS SINGLE
DIM CY AS SINGLE
DIM Sy AS SINGLE
DIM CZ AS SINGLE
DIM SZ AS SINGLE

DIM TX1 AS SINGLE           'Temporary precalcs for speed
DIM TY1 AS SINGLE
DIM TZ1 AS SINGLE
DIM TX2 AS SINGLE
DIM TY2 AS SINGLE
DIM TZ2 AS SINGLE
DIM TX3 AS SINGLE
DIM TY3 AS SINGLE
DIM TZ3 AS SINGLE

DIM RotX AS SINGLE         'Temporay rotated values
DIM RotY AS SINGLE
DIM RotZ AS SINGLE

DIM Distance AS INTEGER     'needs this for projection


'Precalculate the SIN and COS of each angle
CX = LCOS(AngleX)
Sx = LSIN(AngleX)
CY = LCOS(AngleY)
Sy = LSIN(AngleY)
CZ = LCOS(AngleZ)
SZ = LSIN(AngleZ)


'Precalculate Rotations
'Entrophy made this precalcs
'for a 3*3 matrix to reduce the calcs from 12 to 9 on the inside loop
'Though we have a different Projection formula.

TX1 = CY * CZ
TY1 = -CY * SZ
TZ1 = Sy
TX2 = Sx * Sy * CZ + CX * SZ
TY2 = CX * CZ - Sx * Sy * SZ
TZ2 = -Sx * CY
TX3 = Sx * SZ - CX * Sy * CZ
TY3 = Sx * CZ + CX * Sy * SZ
TZ3 = CX * CY


FOR I = 1 TO UBOUND(Model)

        X = Model(I).X       'Load Original model
        Y = Model(I).Y
        Z = Model(I).Z

        RotX = X * TX1 + Y * TX2 + Z * TX3      'Rotate the Axes
        RotY = X * TY1 + Y * TY2 + Z * TY3
        RotZ = X * TZ1 + Y * TZ2 + Z * TZ3

        Model(I).Xr = RotX          'Store 'em
        Model(I).Yr = RotY
        Model(I).Zr = RotZ


        'Project
        Distance = (256 - RotZ)
        IF Distance THEN
            Model(I).ScrX = (ZCenter * RotX / Distance) + XCenter + CamX
            Model(I).ScrY = -(ZCenter * RotY / Distance) + YCenter + CamY
        ELSE
        END IF
NEXT I

END SUB

